#pragma once
#include <QObject>

class QDateTime;
class QTimer;

class DateTime : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QString currentTime READ currentTime WRITE setCurrentTime NOTIFY currentTimeChanged)
    Q_PROPERTY(QString currentDate READ currentDate WRITE setCurrentDate NOTIFY currentDateChanged)

public:
    explicit DateTime(QObject *parent = nullptr);
    QString currentTime() { return m_currentTime; }
    QString currentDate() { return m_currentDate; }

signals:
    void currentTimeChanged();
    void currentDateChanged();

private:
    void setCurrentTime(const QString &currentTime);
    void setCurrentDate(const QString &currentDate);
    QDateTime *m_dateTime = nullptr;
    QTimer *m_timer = nullptr;
    QString m_currentTime;
    QString m_currentDate;
};
